<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
  <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
  <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <title lang="en">Station Offset Elevation Feature Report</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <h2 lang="en">Station Offset Elevation Feature Report</h2>
                <p lang="en">
                  Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                  Time:&#xa0; <xsl:value-of select="cif:time()"/>
                </p>
              </center>

              <xsl:for-each select="GeometryProject">
                <table class="margin" cellpadding="2" width="90%">
                  <tbody>
                    <tr>
                      <th align="right" lang="en">Project:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@name"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Description:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@description"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Baseline (Active) Alignment:</th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="HorizontalAlignment/@name"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">File Name:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@file"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Last Revised:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                      <td align="left" style="font-size: 80%">
                        <xsl:value-of select="../@inputGridScaleFactor" />
                      </td>
                      <td align="right" lang="en" style="font-size: 80%">
                        <strong>Note:&#xa0; </strong>All units in this report are in
                        <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                        <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                        unless specified otherwise.
                      </td>
                    </tr>
                  </tbody>
                </table>
                <hr/>

                <!-- From Custom Point Station Offset Elevation Feature command -->
                <xsl:for-each select="HorizontalAlignment[OffsetPoint]">
                  <table cellspacing="4" width="100%">
                    <thead style="display:table-header-group">
                      <tr>
                        <th class="underline" lang="en" align="left">Point</th>
                        <th class="underline" lang="en" align="left">Description</th>
                        <th class="underline" lang="en" align="left">Station</th>
                        <th class="underline" lang="en" align="left">Offset</th>
                        <th class="underline" lang="en" align="left">Elevation</th>
                        <th class="underline" lang="en" align="left">Feature</th>
                      </tr>
                    </thead>
                    <tbody>
                        <xsl:for-each select="OffsetPoint/GeometryPointProperties">
                          <tr>
                            <td align="left">
                              <xsl:value-of select="@PointName"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="@PointDescription"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="cif:stationFormat(number(station/@externalStation),string(station/@externalStationName))"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="cif:distanceFormat(number(@offset))"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="@FeatureName"/>
                            </td>
                          </tr>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </xsl:for-each>

                <!--From Alignment Station Offset command -->
                <xsl:for-each select="HorizontalAlignment[StationOffsetPoints]">
                  <table cellspacing="4" width="100%">

                    <tbody>
                      <xsl:for-each select="StationOffsetPoints/StationOffsetPoint">
                        <tr>
                          <xsl:if test="not(@offsetAlignmentName = preceding-sibling::*/@offsetAlignmentName)">
                            <tr>
                              <th class="underline" lang="en" align="left">
                                Baseline Alignment
                                <br>
                                  (<xsl:value-of select="../../../HorizontalAlignment/@name"/>)
                                </br>
                                <br />
                                Point Type
                              </th>
                              <th class="underline" lang="en" align="left">
                                Offset Alignment
                                <br>
                                  (<xsl:value-of select="@offsetAlignmentName"/>)
                                </br>
                                <br />
                                Point Name
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Baseline Alignment<br />Station
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Baseline Alignment<br />Offset
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Offset Alignment<br />Elevation
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Offset Alignment<br />Feature
                              </th>
                            </tr>
                          </xsl:if>
                          <td align="left">
                            <xsl:value-of select="centerLinePoint/point/@type"/>
                          </td>
                          <td align="left">
                            <xsl:value-of select="offsetPoint/@name"/>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation),string(centerLinePoint/point/station/@externalStationName))"/>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:distanceFormat(number(@firstOffset))"/>
                          </td>
                          <td align="left">
                            <xsl:if test="offsetPoint/@elevation">
                              <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@elevation))"/>
                            </xsl:if>
                          </td>
                          <td align="left">
                            <xsl:value-of select="@FeatureName"/>
                          </td>
                        </tr>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </xsl:for-each>

              </xsl:for-each>

            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Notes</h4>
      <p class="normal1" lang="en">
        You must create station offset points for this report by selecting <em>
          Tools &gt; XML
          Reports &gt; Station Offset
        </em>.
      </p>
      <p class="normal1" lang="en">
        You must include at least one horizontal alignment or one feature on the <em>General</em>
        leaf in the <em>From</em> fields.
      </p>
      <p class="normal1" lang="en">
        You must also include at least one horizontal alignment on the <em>
          Horizontal Alignments
        </em> leaf or one feature on the <em> Features</em> leaf.
      </p>
      <p class="normal1" lang="en">
        You must choose at least one option on the <em>Include</em> leaf (<em>
          Horizontal On-
          Alignment Points, Horizontal Event Points, Vertical On-Alignment Points, Vertical Event
          Points
        </em> or <em>Interval</em>.)
      </p>
      <p class="small" lang="en">
        <em>&#xa9; 2013 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
